import es
import random
import gamethread
import playerlib

import wcs
from wcs import wcs

raceName = 'Priestess of the Moon'
race     = wcs.Race(raceName)

""" ############################### """
""" ### Begin the configuration ### """
""" ############################### """

config   = race.config()

raceMinLevel     = config.addVar('priestessMinLevel', 50, 'The total level required before you are able to play the race.')

config.addComment()
config.addComment('********************')
config.addComment('Trueshot Aura')
config.addComment('    All nearby allies have increased')
config.addComment('    damage.')
config.addComment('********************')
config.addComment()
trueMaxLevel      = config.addVar('trueMaxlevel',       3, 'The maximum level of the Trueshot Aura skill') 
trueLevelInterval = config.addVar('trueLevelInterval',  2, 'The intervals between the abilities to upgrade their Trueshot Aura skill')

config.addComment()
config.addComment('********************')
config.addComment('Searing Arrows')
config.addComment('    The player exchanges some cash to')
config.addComment('    deal extra damage and set the victim')
config.addComment('    on fire.')
config.addComment('********************')
config.addComment()
arrowsMaxLevel      = config.addVar('arrowsMaxLevel',       3, 'The maximum level of the Searing Arrows skill') 
arrowsLevelInterval = config.addVar('arrowsLevelInterval',  2, 'The intervals between the abilities to upgrade their Searing Arrows skill')

config.addComment()
config.addComment('********************')
config.addComment('Moon Glaive')
config.addComment('    This skill allows damage')
config.addComment('    to jump from person to person')
config.addComment('    each time the damage decreasing.')
config.addComment('********************')
config.addComment()
moonMaxLevel      = config.addVar('moonMaxLevel',       5, 'The maximum level of the Moon Glaive skill') 
moonLevelInterval = config.addVar('moonLevelInterval',  1, 'The intervals between the abilities to upgrade their Moon Glaive skill')

config.addComment()
config.addComment('********************')
config.addComment('Moon Glaive')
config.addComment('    This skill allows damage')
config.addComment('    to jump from person to person')
config.addComment('    each time the damage decreasing.')
config.addComment('********************')
config.addComment()
starMinLevel      = config.addVar('starMinLevel',       6, 'The level required before a player can acquire level 1 of the Star Fall skill.')
starMaxLevel      = config.addVar('starMaxLevel',       3, 'The maximum level of the Star Fall skill') 
starLevelInterval = config.addVar('starLevelInterval',  4, 'The intervals between the abilities to upgrade their Star Fall skill')

config.load(True)

""" ##################### """
""" ### END OF CONFIG ### """
""" ##################### """

race.registerSkill('Trueshot Aura',  int(trueMaxLevel),   int(trueLevelInterval),   'Yourself and all nearby allies have increased damage.')
race.registerSkill('Searing Arrows', int(arrowsMaxLevel), int(arrowsLevelInterval), 'Your hits deal extra damage and set fire to the target in exchange for some cash.')
race.registerSkill('Moon Glaive',    int(moonMaxLevel),   int(moonLevelInterval),   'You attacks jump from target to target, each jump lessens the damage.')
race.registerUltimate('StarFall',    int(starMinLevel),   int(starMaxLevel), int(starLevelInterval), 'Hold your ultimate to deal damage to all near by oppents.')

race.registerMinLevel(int(raceMinLevel))

race.registerWeaponRestriction('block only', ('m3','xm1014'))

def player_spawn(ev):
    userid    = int(ev['userid'])
    auralevel = wcs.GetLevel(userid, raceName,'Trueshot Aura')
    wcs.Command(userid)['trueshot list'] = []
    if auralevel:
        wcs.Command(userid)['true shot bonus'] = auralevel * 0.1
        if not wcs.Command(userid)['looping']:
            aura_loop(userid)
			
def aura_loop(userid):
    global truelist
    if not wcs.Command(userid).IsDead() and es.exists('userid', userid):
        wcs.Command(userid)['looping'] = 1
        truelist = wcs.Command(userid)['trueshot list']
        for user in truelist:
            wcs.Command(userid)['true shot bonus'] = 0
        truelist = []
        team = int(es.getplayerteam(userid))
        filter = '#t' if team == 2 else '#ct'
        wcs.Command(userid).Near(240, auraset, filter)
        wcs.Command(userid)['trueshot list'] = truelist
    else:
        wcs.Command(userid)['looping'] = 0
		
def auraset(userid, auramaster):
	truelist.append(userid)
	wcs.Command(userid)['true shot bonus'] = wcs.GetLevel(auramaster, raceName, 'Trueshot Aura') * 0.1
	auraeffect(userid)
	gamethread.delayed(0.45, auraeffect, userid)
	gamethread.delayed(0.90, auraeffect, userid)
	gamethread.delayed(1.35, auraeffect, userid)
	
def auraeffect(userid):
	wcs.effect.Ring1(userid, 40, 0.5, 255, 255, 255)
	
def player_hurt(ev):
    userid     = int(ev['userid'])
    attacker   = int(ev['attacker'])
    userPlayer = playerlib.getPlayer(userid)
    if attacker:
        attackerPlayer = playerlib.getPlayer(attacker)
        damage         = int(ev['dmg_health'])
        glaive         = wcs.GetLevel(attacker, raceName, 'Moon Glaive')
        if glaive:
            team   = int(es.getplayerteam(attacker))
            filter = '#ct' if team == 2 else '#t'
            x,y,z  = es.getplayerlocation(userid)
            plist  = wcs.Command(userid).GetNearCoordList(x, y, z, 120, 120, 120, filter)
            if plist:
                choice = random.choice(plist)
                wcs.Command(choice).Damage(damage / 2, 32, attacker)
                wcs.effect.Beam2(userid, choice, 1.5, 128, 42, 42)
        searing = wcs.GetLevel(attacker, raceName, 'Searing Arrows')
        if searing:
            cash = attackerPlayer.get('cash')
            if cash >= (searing*10):
                attackerPlayer.set('cash', cash-searing*10)
                wcs.Command(userid).Burn(1)
                wcs.Command(userid).Damage(searing * 3, 32, attacker)
        attackerkey = wcs.Command(attacker).ReturnUserKey()
        if attackerkey.has_key('true shot bonus'):
            wcs.Command(userid).Damage(damage * attackerkey['true shot bonus'], 32, attacker)
			
def player_ultimate_on(ev):
    userid   = int(ev['userid'])
    starfall = wcs.GetLevel(userid, raceName, 'StarFall')
    if starfall:
        wcs.Command(userid)['star falling'] = 1
        wcs.Command(userid).Freeze()
        gamethread.delayed(starfall * 15, ultiOff, userid)
        star_loop(userid)
		
def star_loop(userid):
    if wcs.Command(userid)['star falling']:
        wcs.effect.Ring2(userid, 50, 1.6, 191, 62, 255)
        wcs.effect.Misc1(userid, 1.6)
        gamethread.delayed(1.5, star_loop, userid)
        team   = int(es.getplayerteam(attacker))
        filter = '#ct' if team == 2 else '#t'
        wcs.Command(userid).Near(800, star_target, filter)
        wcs.Command(userid).Delayed(1.5, star_loop, userid, True)
		
def star_target(userid, attacker):
    if wcs.isEst:
        wcs.Command(userid).GetWallBetween(star_target_safe, attacker)
    else:
        start_target_safe(userid, 0, attacker)
        
def star_target_safe(userid, wallBetween, attacker):
    if not wallBetween:
        wcs.Command(userid).Damage(50, 32, attacker)
        x, y, z = es.getplayerlocation(userid)
        if wcs.isEst:
            es.server.queuecmd('est_effect 3 #a 0 sprites/lgtning.vmt %s %s %s %s %s %s %s 40 10 %s %s %s 255' % (x, y, z + 300, x, y, z + 30, 2, 191, 62, 255) )
		
def player_ultimate_off(ev):
    userid = int(ev['userid'])
    if not wcs.Command(userid).GetCoolDown('StarFall'):
        ultiOff(userid)
		
def ultiOff(userid):
    if wcs.Command(userid)['star falling']:
        wcs.Command(userid)['star falling'] = 0
        wcs.Command(userid).UnFreeze()
